#!/bin/bash
chmod +x downloadassets.sh
if [ "$1" == "" ]; then
    1>&2 echo Error: missing argument: version
    1>&2 echo "Usage: archiveversion.sh <version> [stage] \"[server]\""
    1>&2 echo "Eg: archiveversion.sh 0.19.1 Prod \"https://emuferal.ddns.net/feralassets\""
    exit 1
fi

echo Finding charts...
version="$1"
stage="Prod"
if [ "$2" != "" ]; then
    stage="$2"
fi
server="https://game-assets.fer.al"
if [ "$3" != "" ]; then
    server="$3"
fi
versionfolder="${stage}_v${version//./_}"
urlBase="$server/$versionfolder"
if ! curl -fk "$urlBase/charts/charts_shared_hash.txt" &>/dev/null ; then
    1>&2 echo "Error: could not find version in the game asset server (version: $stage $version)"
    exit 1
fi

echo Preparing...
if [ -d "$versionfolder" ]; then
    1>&2 echo -n "WARNING! Found $versionfolder on disk, are you sure you want to continue? [Y/n] "
    read -r confirm
    if [ "${confirm,,}" != "y" ]; then
        exit 1
    fi
    echo Continuing with existing folder...
fi
mkdir -p "$versionfolder/charts"
mkdir -p "$versionfolder/assetBundles"

echo Downloading shared charts...
echo Downloading "$urlBase/charts/charts_shared_hash.txt"...
curl -fk "$urlBase/charts/charts_shared_hash.txt" > "$versionfolder/charts/charts_shared_hash.txt" || exit 1
hash="$(cat "$versionfolder/charts/charts_shared_hash.txt")"
echo Downloading "$urlBase/charts/charts_shared.$hash.db"...
curl -fk "$urlBase/charts/charts_shared.$hash.db" > "$versionfolder/charts/charts_shared.$hash.db" || exit 1

function downloadPlatform() {
    platform="$1"
    echo Downloading "$platform" files...
    echo Downloading "$urlBase/charts/charts_bundles_${platform}_hash.txt"...
    curl -fk "$urlBase/charts/charts_bundles_${platform}_hash.txt" > "$versionfolder/charts/charts_bundles_${platform}_hash.txt" || exit 1
    hash="$(cat "$versionfolder/charts/charts_bundles_${platform}_hash.txt")"
    echo Downloading "$urlBase/charts/charts_bundles_${platform}.$hash.db"...
    curl -fk "$urlBase/charts/charts_bundles_${platform}.$hash.db" > "$versionfolder/charts/charts_bundles_${platform}.$hash.db" || exit 1
    
    echo Decrypting charts...
    if ! python ChartDecrypt.py "$versionfolder/charts/charts_bundles_${platform}.$hash.db" "feral" "$stage" _v"${version//./_}" "$platform" ; then
        rm -f "$versionfolder/charts/charts_bundles_${platform}.$hash.db.decrypted.db"
        exit 1
    fi
    rm -f "$versionfolder/charts/charts_bundles_${platform}.$hash.db.decrypted.db"
    echo Downloading assets...
    ./downloadassets.sh "feral-$versionfolder-$platform-game-assets.txt" "$versionfolder/assetBundles/$platform" "$platform" "$server"
    rm "feral-$versionfolder-$platform-game-assets.txt"
}

downloadPlatform "win32"
downloadPlatform "osx"
downloadPlatform "android"
downloadPlatform "ios"
